/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int fg_flag;	/**< @brief Run in foreground (default=off).  */
  const char *fg_help; /**< @brief Run in foreground help description.  */
  int debug_flag;	/**< @brief Run in debug mode (default=off).  */
  const char *debug_help; /**< @brief Run in debug mode help description.  */
  char * bin_arg;	/**< @brief Binary config file.  */
  char * bin_orig;	/**< @brief Binary config file original value given at command line.  */
  const char *bin_help; /**< @brief Binary config file help description.  */
  int reload_flag;	/**< @brief Send reload after reconfigure (default=off).  */
  const char *reload_help; /**< @brief Send reload after reconfigure help description.  */
  int debugfacility_arg;	/**< @brief Which modules to print debug messages for (default='1').  */
  char * debugfacility_orig;	/**< @brief Which modules to print debug messages for original value given at command line.  */
  const char *debugfacility_help; /**< @brief Which modules to print debug messages for help description.  */
  int logfacility_arg;	/**< @brief Syslog facility to be used for logging (default='-1').  */
  char * logfacility_orig;	/**< @brief Syslog facility to be used for logging original value given at command line.  */
  const char *logfacility_help; /**< @brief Syslog facility to be used for logging help description.  */
  char * conf_arg;	/**< @brief Read configuration file.  */
  char * conf_orig;	/**< @brief Read configuration file original value given at command line.  */
  const char *conf_help; /**< @brief Read configuration file help description.  */
  int interval_arg;	/**< @brief Re-read configuration file at this interval (default='3600').  */
  char * interval_orig;	/**< @brief Re-read configuration file at this interval original value given at command line.  */
  const char *interval_help; /**< @brief Re-read configuration file at this interval help description.  */
  char * pidfile_arg;	/**< @brief Filename of process id file.  */
  char * pidfile_orig;	/**< @brief Filename of process id file original value given at command line.  */
  const char *pidfile_help; /**< @brief Filename of process id file help description.  */
  char * statedir_arg;	/**< @brief Directory of nonvolatile data.  */
  char * statedir_orig;	/**< @brief Directory of nonvolatile data original value given at command line.  */
  const char *statedir_help; /**< @brief Directory of nonvolatile data help description.  */
  int uid_arg;	/**< @brief UID to run as, after being started as root (default='0').  */
  char * uid_orig;	/**< @brief UID to run as, after being started as root original value given at command line.  */
  const char *uid_help; /**< @brief UID to run as, after being started as root help description.  */
  int gid_arg;	/**< @brief GID to run as, after being started as root (default='0').  */
  char * gid_orig;	/**< @brief GID to run as, after being started as root original value given at command line.  */
  const char *gid_help; /**< @brief GID to run as, after being started as root help description.  */
  char * net_arg;	/**< @brief Network (default='192.168.182.0/24').  */
  char * net_orig;	/**< @brief Network original value given at command line.  */
  const char *net_help; /**< @brief Network help description.  */
  int dhcpstart_arg;	/**< @brief Network DHCP Starting IP (default='0').  */
  char * dhcpstart_orig;	/**< @brief Network DHCP Starting IP original value given at command line.  */
  const char *dhcpstart_help; /**< @brief Network DHCP Starting IP help description.  */
  int dhcpend_arg;	/**< @brief Network DHCP Ending IP (default='0').  */
  char * dhcpend_orig;	/**< @brief Network DHCP Ending IP original value given at command line.  */
  const char *dhcpend_help; /**< @brief Network DHCP Ending IP help description.  */
  int dhcpbroadcast_flag;	/**< @brief Always broadcast DHCP responses (default=off).  */
  const char *dhcpbroadcast_help; /**< @brief Always broadcast DHCP responses help description.  */
  char * dynip_arg;	/**< @brief Dynamic IP address pool.  */
  char * dynip_orig;	/**< @brief Dynamic IP address pool original value given at command line.  */
  const char *dynip_help; /**< @brief Dynamic IP address pool help description.  */
  int nodynip_flag;	/**< @brief No Dynamic IP assignment (default=off).  */
  const char *nodynip_help; /**< @brief No Dynamic IP assignment help description.  */
  char * statip_arg;	/**< @brief Static IP address pool.  */
  char * statip_orig;	/**< @brief Static IP address pool original value given at command line.  */
  const char *statip_help; /**< @brief Static IP address pool help description.  */
  char * anyipexclude_arg;	/**< @brief Network to exclude from uamanyip.  */
  char * anyipexclude_orig;	/**< @brief Network to exclude from uamanyip original value given at command line.  */
  const char *anyipexclude_help; /**< @brief Network to exclude from uamanyip help description.  */
  char * dns1_arg;	/**< @brief Primary DNS server IP address.  */
  char * dns1_orig;	/**< @brief Primary DNS server IP address original value given at command line.  */
  const char *dns1_help; /**< @brief Primary DNS server IP address help description.  */
  char * dns2_arg;	/**< @brief Secondary DNS server IP address.  */
  char * dns2_orig;	/**< @brief Secondary DNS server IP address original value given at command line.  */
  const char *dns2_help; /**< @brief Secondary DNS server IP address help description.  */
  char * domain_arg;	/**< @brief Domain to use for DNS lookups (default='coova.org').  */
  char * domain_orig;	/**< @brief Domain to use for DNS lookups original value given at command line.  */
  const char *domain_help; /**< @brief Domain to use for DNS lookups help description.  */
  char * ipup_arg;	/**< @brief Script to run after link-up.  */
  char * ipup_orig;	/**< @brief Script to run after link-up original value given at command line.  */
  const char *ipup_help; /**< @brief Script to run after link-up help description.  */
  char * ipdown_arg;	/**< @brief Script to run after link-down.  */
  char * ipdown_orig;	/**< @brief Script to run after link-down original value given at command line.  */
  const char *ipdown_help; /**< @brief Script to run after link-down help description.  */
  char * conup_arg;	/**< @brief Script to run after user logon.  */
  char * conup_orig;	/**< @brief Script to run after user logon original value given at command line.  */
  const char *conup_help; /**< @brief Script to run after user logon help description.  */
  char * condown_arg;	/**< @brief Script to run after user logoff.  */
  char * condown_orig;	/**< @brief Script to run after user logoff original value given at command line.  */
  const char *condown_help; /**< @brief Script to run after user logoff help description.  */
  int txqlen_arg;	/**< @brief TX Queue length for tun interface (linux only) (default='100').  */
  char * txqlen_orig;	/**< @brief TX Queue length for tun interface (linux only) original value given at command line.  */
  const char *txqlen_help; /**< @brief TX Queue length for tun interface (linux only) help description.  */
  char * tundev_arg;	/**< @brief TUN/TAP Device, as in tun0 or tap1.  */
  char * tundev_orig;	/**< @brief TUN/TAP Device, as in tun0 or tap1 original value given at command line.  */
  const char *tundev_help; /**< @brief TUN/TAP Device, as in tun0 or tap1 help description.  */
  int mtu_arg;	/**< @brief MTU given in DHCP (default='1500').  */
  char * mtu_orig;	/**< @brief MTU given in DHCP original value given at command line.  */
  const char *mtu_help; /**< @brief MTU given in DHCP help description.  */
  int autostatip_arg;	/**< @brief Auto- static ip assignment (default='0').  */
  char * autostatip_orig;	/**< @brief Auto- static ip assignment original value given at command line.  */
  const char *autostatip_help; /**< @brief Auto- static ip assignment help description.  */
  int ringsize_arg;	/**< @brief TX/RX Ring Size (in kbytes; linux only) (default='0').  */
  char * ringsize_orig;	/**< @brief TX/RX Ring Size (in kbytes; linux only) original value given at command line.  */
  const char *ringsize_help; /**< @brief TX/RX Ring Size (in kbytes; linux only) help description.  */
  int sndbuf_arg;	/**< @brief SNDBUF size (in kb) (default='0').  */
  char * sndbuf_orig;	/**< @brief SNDBUF size (in kb) original value given at command line.  */
  const char *sndbuf_help; /**< @brief SNDBUF size (in kb) help description.  */
  int rcvbuf_arg;	/**< @brief RCVBUF size (in kb) (default='0').  */
  char * rcvbuf_orig;	/**< @brief RCVBUF size (in kb) original value given at command line.  */
  const char *rcvbuf_help; /**< @brief RCVBUF size (in kb) help description.  */
  char * radiuslisten_arg;	/**< @brief IP address to send from.  */
  char * radiuslisten_orig;	/**< @brief IP address to send from original value given at command line.  */
  const char *radiuslisten_help; /**< @brief IP address to send from help description.  */
  char * radiusserver1_arg;	/**< @brief IP address of radius server 1.  */
  char * radiusserver1_orig;	/**< @brief IP address of radius server 1 original value given at command line.  */
  const char *radiusserver1_help; /**< @brief IP address of radius server 1 help description.  */
  char * radiusserver2_arg;	/**< @brief IP address of radius server 2.  */
  char * radiusserver2_orig;	/**< @brief IP address of radius server 2 original value given at command line.  */
  const char *radiusserver2_help; /**< @brief IP address of radius server 2 help description.  */
  int radiusauthport_arg;	/**< @brief Authentication UDP port of radius server (default='1812').  */
  char * radiusauthport_orig;	/**< @brief Authentication UDP port of radius server original value given at command line.  */
  const char *radiusauthport_help; /**< @brief Authentication UDP port of radius server help description.  */
  int radiusacctport_arg;	/**< @brief Accounting UDP port of radius server (default='1813').  */
  char * radiusacctport_orig;	/**< @brief Accounting UDP port of radius server original value given at command line.  */
  const char *radiusacctport_help; /**< @brief Accounting UDP port of radius server help description.  */
  char * radiussecret_arg;	/**< @brief Radius shared secret (default='testing123').  */
  char * radiussecret_orig;	/**< @brief Radius shared secret original value given at command line.  */
  const char *radiussecret_help; /**< @brief Radius shared secret help description.  */
  int radiustimeout_arg;	/**< @brief Retry timeout in seconds (default='10').  */
  char * radiustimeout_orig;	/**< @brief Retry timeout in seconds original value given at command line.  */
  const char *radiustimeout_help; /**< @brief Retry timeout in seconds help description.  */
  int radiusretry_arg;	/**< @brief Total number of retries (default='4').  */
  char * radiusretry_orig;	/**< @brief Total number of retries original value given at command line.  */
  const char *radiusretry_help; /**< @brief Total number of retries help description.  */
  int radiusretrysec_arg;	/**< @brief Number of retries before using secondary (default='2').  */
  char * radiusretrysec_orig;	/**< @brief Number of retries before using secondary original value given at command line.  */
  const char *radiusretrysec_help; /**< @brief Number of retries before using secondary help description.  */
  char * radiusnasid_arg;	/**< @brief Radius NAS-Identifier (default='nas01').  */
  char * radiusnasid_orig;	/**< @brief Radius NAS-Identifier original value given at command line.  */
  const char *radiusnasid_help; /**< @brief Radius NAS-Identifier help description.  */
  char * radiuslocationid_arg;	/**< @brief WISPr Location ID.  */
  char * radiuslocationid_orig;	/**< @brief WISPr Location ID original value given at command line.  */
  const char *radiuslocationid_help; /**< @brief WISPr Location ID help description.  */
  char * radiuslocationname_arg;	/**< @brief WISPr Location Name.  */
  char * radiuslocationname_orig;	/**< @brief WISPr Location Name original value given at command line.  */
  const char *radiuslocationname_help; /**< @brief WISPr Location Name help description.  */
  char * locationname_arg;	/**< @brief Location Name.  */
  char * locationname_orig;	/**< @brief Location Name original value given at command line.  */
  const char *locationname_help; /**< @brief Location Name help description.  */
  int radiusnasporttype_arg;	/**< @brief Radius NAS-Port-Type (default='19').  */
  char * radiusnasporttype_orig;	/**< @brief Radius NAS-Port-Type original value given at command line.  */
  const char *radiusnasporttype_help; /**< @brief Radius NAS-Port-Type help description.  */
  int coaport_arg;	/**< @brief Radius disconnect port to listen to (default='0').  */
  char * coaport_orig;	/**< @brief Radius disconnect port to listen to original value given at command line.  */
  const char *coaport_help; /**< @brief Radius disconnect port to listen to help description.  */
  int coanoipcheck_flag;	/**< @brief Allow radius disconnect from any IP (default=off).  */
  const char *coanoipcheck_help; /**< @brief Allow radius disconnect from any IP help description.  */
  char * proxylisten_arg;	/**< @brief Proxy IP address to listen on.  */
  char * proxylisten_orig;	/**< @brief Proxy IP address to listen on original value given at command line.  */
  const char *proxylisten_help; /**< @brief Proxy IP address to listen on help description.  */
  int proxyport_arg;	/**< @brief Proxy UDP port to listen on (0 is off) (default='0').  */
  char * proxyport_orig;	/**< @brief Proxy UDP port to listen on (0 is off) original value given at command line.  */
  const char *proxyport_help; /**< @brief Proxy UDP port to listen on (0 is off) help description.  */
  char * proxyclient_arg;	/**< @brief IP address of proxy client(s).  */
  char * proxyclient_orig;	/**< @brief IP address of proxy client(s) original value given at command line.  */
  const char *proxyclient_help; /**< @brief IP address of proxy client(s) help description.  */
  char * proxysecret_arg;	/**< @brief Radius proxy shared secret.  */
  char * proxysecret_orig;	/**< @brief Radius proxy shared secret original value given at command line.  */
  const char *proxysecret_help; /**< @brief Radius proxy shared secret help description.  */
  int proxymacaccept_flag;	/**< @brief Auto-accept non-EAP requests on proxy port (default=off).  */
  const char *proxymacaccept_help; /**< @brief Auto-accept non-EAP requests on proxy port help description.  */
  char ** proxylocattr_arg;	/**< @brief The attribute in proxy to be used for the loc= query string parameter.  */
  char ** proxylocattr_orig;	/**< @brief The attribute in proxy to be used for the loc= query string parameter original value given at command line.  */
  unsigned int proxylocattr_min; /**< @brief The attribute in proxy to be used for the loc= query string parameter's minimum occurreces */
  unsigned int proxylocattr_max; /**< @brief The attribute in proxy to be used for the loc= query string parameter's maximum occurreces */
  const char *proxylocattr_help; /**< @brief The attribute in proxy to be used for the loc= query string parameter help description.  */
  char * dhcpif_arg;	/**< @brief Local Ethernet interface.  */
  char * dhcpif_orig;	/**< @brief Local Ethernet interface original value given at command line.  */
  const char *dhcpif_help; /**< @brief Local Ethernet interface help description.  */
  char * dhcpmac_arg;	/**< @brief DHCP Interface MAC Address.  */
  char * dhcpmac_orig;	/**< @brief DHCP Interface MAC Address original value given at command line.  */
  const char *dhcpmac_help; /**< @brief DHCP Interface MAC Address help description.  */
  int dhcpmacset_flag;	/**< @brief Option to have dhcpif configured with dhcpmac (default=off).  */
  const char *dhcpmacset_help; /**< @brief Option to have dhcpif configured with dhcpmac help description.  */
  char * nexthop_arg;	/**< @brief Next Hop MAC address.  */
  char * nexthop_orig;	/**< @brief Next Hop MAC address original value given at command line.  */
  const char *nexthop_help; /**< @brief Next Hop MAC address help description.  */
  int dhcpradius_flag;	/**< @brief Map certain DHCP options to RADIUS attributes (default=off).  */
  const char *dhcpradius_help; /**< @brief Map certain DHCP options to RADIUS attributes help description.  */
  char * dhcpgateway_arg;	/**< @brief DHCP gateway addresss for relay.  */
  char * dhcpgateway_orig;	/**< @brief DHCP gateway addresss for relay original value given at command line.  */
  const char *dhcpgateway_help; /**< @brief DHCP gateway addresss for relay help description.  */
  int dhcpgatewayport_arg;	/**< @brief DHCP gateway port for relay (default='67').  */
  char * dhcpgatewayport_orig;	/**< @brief DHCP gateway port for relay original value given at command line.  */
  const char *dhcpgatewayport_help; /**< @brief DHCP gateway port for relay help description.  */
  char * dhcprelayagent_arg;	/**< @brief DHCP relay agent IP addresss (default uamlisten).  */
  char * dhcprelayagent_orig;	/**< @brief DHCP relay agent IP addresss (default uamlisten) original value given at command line.  */
  const char *dhcprelayagent_help; /**< @brief DHCP relay agent IP addresss (default uamlisten) help description.  */
  int lease_arg;	/**< @brief Lease time to allocate to clients (default='600').  */
  char * lease_orig;	/**< @brief Lease time to allocate to clients original value given at command line.  */
  const char *lease_help; /**< @brief Lease time to allocate to clients help description.  */
  int noc2c_flag;	/**< @brief Setup clients for /32 network (default=off).  */
  const char *noc2c_help; /**< @brief Setup clients for /32 network help description.  */
  int eapolenable_flag;	/**< @brief Enable IEEE 802.1x authentication (default=off).  */
  const char *eapolenable_help; /**< @brief Enable IEEE 802.1x authentication help description.  */
  char * uamserver_arg;	/**< @brief URL of authentication web server.  */
  char * uamserver_orig;	/**< @brief URL of authentication web server original value given at command line.  */
  const char *uamserver_help; /**< @brief URL of authentication web server help description.  */
  char * uamhomepage_arg;	/**< @brief URL of homepage to redirect unauthenticated users to.  */
  char * uamhomepage_orig;	/**< @brief URL of homepage to redirect unauthenticated users to original value given at command line.  */
  const char *uamhomepage_help; /**< @brief URL of homepage to redirect unauthenticated users to help description.  */
  char * uamsecret_arg;	/**< @brief Shared secret between uamserver and chilli.  */
  char * uamsecret_orig;	/**< @brief Shared secret between uamserver and chilli original value given at command line.  */
  const char *uamsecret_help; /**< @brief Shared secret between uamserver and chilli help description.  */
  char * uamlisten_arg;	/**< @brief IP address to listen to for authentication requests.  */
  char * uamlisten_orig;	/**< @brief IP address to listen to for authentication requests original value given at command line.  */
  const char *uamlisten_help; /**< @brief IP address to listen to for authentication requests help description.  */
  char * dhcplisten_arg;	/**< @brief IP address for DHCP default gateway (defaults to uamlisten).  */
  char * dhcplisten_orig;	/**< @brief IP address for DHCP default gateway (defaults to uamlisten) original value given at command line.  */
  const char *dhcplisten_help; /**< @brief IP address for DHCP default gateway (defaults to uamlisten) help description.  */
  int uamport_arg;	/**< @brief TCP port to bind to for authentication requests (default='3990').  */
  char * uamport_orig;	/**< @brief TCP port to bind to for authentication requests original value given at command line.  */
  const char *uamport_help; /**< @brief TCP port to bind to for authentication requests help description.  */
  int uamuiport_arg;	/**< @brief TCP port to bind to for UAM UI requests (default='3991').  */
  char * uamuiport_orig;	/**< @brief TCP port to bind to for UAM UI requests original value given at command line.  */
  const char *uamuiport_help; /**< @brief TCP port to bind to for UAM UI requests help description.  */
  char ** uamallowed_arg;	/**< @brief Domain names exempt from access check .  */
  char ** uamallowed_orig;	/**< @brief Domain names exempt from access check  original value given at command line.  */
  unsigned int uamallowed_min; /**< @brief Domain names exempt from access check 's minimum occurreces */
  unsigned int uamallowed_max; /**< @brief Domain names exempt from access check 's maximum occurreces */
  const char *uamallowed_help; /**< @brief Domain names exempt from access check  help description.  */
  char ** uamdomain_arg;	/**< @brief Domain name allowed (active dns filtering; one per line!) .  */
  char ** uamdomain_orig;	/**< @brief Domain name allowed (active dns filtering; one per line!)  original value given at command line.  */
  unsigned int uamdomain_min; /**< @brief Domain name allowed (active dns filtering; one per line!) 's minimum occurreces */
  unsigned int uamdomain_max; /**< @brief Domain name allowed (active dns filtering; one per line!) 's maximum occurreces */
  const char *uamdomain_help; /**< @brief Domain name allowed (active dns filtering; one per line!)  help description.  */
  char ** uamregex_arg;	/**< @brief Regular expression to match URLs (one per line) .  */
  char ** uamregex_orig;	/**< @brief Regular expression to match URLs (one per line)  original value given at command line.  */
  unsigned int uamregex_min; /**< @brief Regular expression to match URLs (one per line) 's minimum occurreces */
  unsigned int uamregex_max; /**< @brief Regular expression to match URLs (one per line) 's maximum occurreces */
  const char *uamregex_help; /**< @brief Regular expression to match URLs (one per line)  help description.  */
  int uamanydns_flag;	/**< @brief Allow client to use any DNS server (default=off).  */
  const char *uamanydns_help; /**< @brief Allow client to use any DNS server help description.  */
  int uamanyip_flag;	/**< @brief Allow client to use any IP Address (default=off).  */
  const char *uamanyip_help; /**< @brief Allow client to use any IP Address help description.  */
  int uamnatanyip_flag;	/**< @brief Source NAT clients using anyip to an IP of dynip pool (default=off).  */
  const char *uamnatanyip_help; /**< @brief Source NAT clients using anyip to an IP of dynip pool help description.  */
  char * wisprlogin_arg;	/**< @brief A specific WISPr login url to be used.  */
  char * wisprlogin_orig;	/**< @brief A specific WISPr login url to be used original value given at command line.  */
  const char *wisprlogin_help; /**< @brief A specific WISPr login url to be used help description.  */
  int nouamsuccess_flag;	/**< @brief Do not return to the UAM server on success, original url instead (default=off).  */
  const char *nouamsuccess_help; /**< @brief Do not return to the UAM server on success, original url instead help description.  */
  int nowispr1_flag;	/**< @brief Do not offer WISPr 1.0 XML (default=off).  */
  const char *nowispr1_help; /**< @brief Do not offer WISPr 1.0 XML help description.  */
  int nowispr2_flag;	/**< @brief Do not offer WISPr 2.0 XML (default=off).  */
  const char *nowispr2_help; /**< @brief Do not offer WISPr 2.0 XML help description.  */
  char * uamlogoutip_arg;	/**< @brief HTTP Auto-Logout IP Address (default='1.0.0.0').  */
  char * uamlogoutip_orig;	/**< @brief HTTP Auto-Logout IP Address original value given at command line.  */
  const char *uamlogoutip_help; /**< @brief HTTP Auto-Logout IP Address help description.  */
  char * uamaliasip_arg;	/**< @brief Special IP Address aliased (redirect) to uamlisten/uamport (default='1.0.0.1').  */
  char * uamaliasip_orig;	/**< @brief Special IP Address aliased (redirect) to uamlisten/uamport original value given at command line.  */
  const char *uamaliasip_help; /**< @brief Special IP Address aliased (redirect) to uamlisten/uamport help description.  */
  char * uamaliasname_arg;	/**< @brief Special simple hostname (no dots) to be resolved to uamaliasip.  */
  char * uamaliasname_orig;	/**< @brief Special simple hostname (no dots) to be resolved to uamaliasip original value given at command line.  */
  const char *uamaliasname_help; /**< @brief Special simple hostname (no dots) to be resolved to uamaliasip help description.  */
  char * uamhostname_arg;	/**< @brief Special simple hostname (no dots) to be resolved to uamlisten.  */
  char * uamhostname_orig;	/**< @brief Special simple hostname (no dots) to be resolved to uamlisten original value given at command line.  */
  const char *uamhostname_help; /**< @brief Special simple hostname (no dots) to be resolved to uamlisten help description.  */
  char * uamaaaurl_arg;	/**< @brief UAM AAA URL specifying the URL to use for the Chilli HTTP AAA.  */
  char * uamaaaurl_orig;	/**< @brief UAM AAA URL specifying the URL to use for the Chilli HTTP AAA original value given at command line.  */
  const char *uamaaaurl_help; /**< @brief UAM AAA URL specifying the URL to use for the Chilli HTTP AAA help description.  */
  int domaindnslocal_flag;	/**< @brief Option to consider all hostnames in domain as local (default=off).  */
  const char *domaindnslocal_help; /**< @brief Option to consider all hostnames in domain as local help description.  */
  int radsec_flag;	/**< @brief Use RadSec tunning (requires SSL; not compatible with uamaaaurl) (default=off).  */
  const char *radsec_help; /**< @brief Use RadSec tunning (requires SSL; not compatible with uamaaaurl) help description.  */
  long defsessiontimeout_arg;	/**< @brief Default session-timeout if not returned by RADIUS (default='0').  */
  char * defsessiontimeout_orig;	/**< @brief Default session-timeout if not returned by RADIUS original value given at command line.  */
  const char *defsessiontimeout_help; /**< @brief Default session-timeout if not returned by RADIUS help description.  */
  int defidletimeout_arg;	/**< @brief Default idle-timeout if not returned by RADIUS (default='0').  */
  char * defidletimeout_orig;	/**< @brief Default idle-timeout if not returned by RADIUS original value given at command line.  */
  const char *defidletimeout_help; /**< @brief Default idle-timeout if not returned by RADIUS help description.  */
  long defbandwidthmaxdown_arg;	/**< @brief Default WISPr-Bandwidth-Max-Down if not returned by RADIUS (default='0').  */
  char * defbandwidthmaxdown_orig;	/**< @brief Default WISPr-Bandwidth-Max-Down if not returned by RADIUS original value given at command line.  */
  const char *defbandwidthmaxdown_help; /**< @brief Default WISPr-Bandwidth-Max-Down if not returned by RADIUS help description.  */
  long defbandwidthmaxup_arg;	/**< @brief Default WISPr-Bandwidth-Max-Up if not returned by RADIUS (default='0').  */
  char * defbandwidthmaxup_orig;	/**< @brief Default WISPr-Bandwidth-Max-Up if not returned by RADIUS original value given at command line.  */
  const char *defbandwidthmaxup_help; /**< @brief Default WISPr-Bandwidth-Max-Up if not returned by RADIUS help description.  */
  int definteriminterval_arg;	/**< @brief Default interim-interval for accounting if not returned by RADIUS (default='300').  */
  char * definteriminterval_orig;	/**< @brief Default interim-interval for accounting if not returned by RADIUS original value given at command line.  */
  const char *definteriminterval_help; /**< @brief Default interim-interval for accounting if not returned by RADIUS help description.  */
  int bwbucketupsize_arg;	/**< @brief Define the up-bound 'leaky bucket' size (default='0').  */
  char * bwbucketupsize_orig;	/**< @brief Define the up-bound 'leaky bucket' size original value given at command line.  */
  const char *bwbucketupsize_help; /**< @brief Define the up-bound 'leaky bucket' size help description.  */
  int bwbucketdnsize_arg;	/**< @brief Define the down-bound 'leaky bucket' size (default='0').  */
  char * bwbucketdnsize_orig;	/**< @brief Define the down-bound 'leaky bucket' size original value given at command line.  */
  const char *bwbucketdnsize_help; /**< @brief Define the down-bound 'leaky bucket' size help description.  */
  int bwbucketminsize_arg;	/**< @brief Define the minimum 'leaky bucket' size (default='0').  */
  char * bwbucketminsize_orig;	/**< @brief Define the minimum 'leaky bucket' size original value given at command line.  */
  const char *bwbucketminsize_help; /**< @brief Define the minimum 'leaky bucket' size help description.  */
  int macauth_flag;	/**< @brief Authenticate based on MAC address (default=off).  */
  const char *macauth_help; /**< @brief Authenticate based on MAC address help description.  */
  int macreauth_flag;	/**< @brief Re-Authenticate based on MAC address for every initial URL redirection (default=off).  */
  const char *macreauth_help; /**< @brief Re-Authenticate based on MAC address for every initial URL redirection help description.  */
  int macauthdeny_flag;	/**< @brief Deny access (even UAM) to MAC addresses given Access-Reject (default=off).  */
  const char *macauthdeny_help; /**< @brief Deny access (even UAM) to MAC addresses given Access-Reject help description.  */
  char ** macallowed_arg;	/**< @brief List of allowed MAC addresses.  */
  char ** macallowed_orig;	/**< @brief List of allowed MAC addresses original value given at command line.  */
  unsigned int macallowed_min; /**< @brief List of allowed MAC addresses's minimum occurreces */
  unsigned int macallowed_max; /**< @brief List of allowed MAC addresses's maximum occurreces */
  const char *macallowed_help; /**< @brief List of allowed MAC addresses help description.  */
  char * macsuffix_arg;	/**< @brief Suffix to add to the MAC address.  */
  char * macsuffix_orig;	/**< @brief Suffix to add to the MAC address original value given at command line.  */
  const char *macsuffix_help; /**< @brief Suffix to add to the MAC address help description.  */
  char * macpasswd_arg;	/**< @brief Password used when performing MAC authentication.  */
  char * macpasswd_orig;	/**< @brief Password used when performing MAC authentication original value given at command line.  */
  const char *macpasswd_help; /**< @brief Password used when performing MAC authentication help description.  */
  int macallowlocal_flag;	/**< @brief Do not use RADIUS for authenticating the macallowed (default=off).  */
  const char *macallowlocal_help; /**< @brief Do not use RADIUS for authenticating the macallowed help description.  */
  int strictmacauth_flag;	/**< @brief Be strict about MAC Auth (no DHCP reply until we get RADIUS reply) (default=off).  */
  const char *strictmacauth_help; /**< @brief Be strict about MAC Auth (no DHCP reply until we get RADIUS reply) help description.  */
  char * wwwdir_arg;	/**< @brief Local content served by chilli (for splash page, etc).  */
  char * wwwdir_orig;	/**< @brief Local content served by chilli (for splash page, etc) original value given at command line.  */
  const char *wwwdir_help; /**< @brief Local content served by chilli (for splash page, etc) help description.  */
  char * wwwbin_arg;	/**< @brief Script binary (such as haserl) for simple web programming.  */
  char * wwwbin_orig;	/**< @brief Script binary (such as haserl) for simple web programming original value given at command line.  */
  const char *wwwbin_help; /**< @brief Script binary (such as haserl) for simple web programming help description.  */
  char * uamui_arg;	/**< @brief Program in inetd style to handle all uam requests.  */
  char * uamui_orig;	/**< @brief Program in inetd style to handle all uam requests original value given at command line.  */
  const char *uamui_help; /**< @brief Program in inetd style to handle all uam requests help description.  */
  char * adminuser_arg;	/**< @brief RADIUS administrative user login username.  */
  char * adminuser_orig;	/**< @brief RADIUS administrative user login username original value given at command line.  */
  const char *adminuser_help; /**< @brief RADIUS administrative user login username help description.  */
  char * adminpasswd_arg;	/**< @brief RADIUS administrative user login password.  */
  char * adminpasswd_orig;	/**< @brief RADIUS administrative user login password original value given at command line.  */
  const char *adminpasswd_help; /**< @brief RADIUS administrative user login password help description.  */
  char * adminupdatefile_arg;	/**< @brief File for administrative user ChilliSpot-Config settings.  */
  char * adminupdatefile_orig;	/**< @brief File for administrative user ChilliSpot-Config settings original value given at command line.  */
  const char *adminupdatefile_help; /**< @brief File for administrative user ChilliSpot-Config settings help description.  */
  char * rtmonfile_arg;	/**< @brief File to update with routing settings.  */
  char * rtmonfile_orig;	/**< @brief File to update with routing settings original value given at command line.  */
  const char *rtmonfile_help; /**< @brief File to update with routing settings help description.  */
  char * ethers_arg;	/**< @brief File containing a mapping of MAC addresses to static IP addresses.  */
  char * ethers_orig;	/**< @brief File containing a mapping of MAC addresses to static IP addresses original value given at command line.  */
  const char *ethers_help; /**< @brief File containing a mapping of MAC addresses to static IP addresses help description.  */
  char * nasmac_arg;	/**< @brief Unique MAC address of the NAS (called-station-id).  */
  char * nasmac_orig;	/**< @brief Unique MAC address of the NAS (called-station-id) original value given at command line.  */
  const char *nasmac_help; /**< @brief Unique MAC address of the NAS (called-station-id) help description.  */
  char * nasip_arg;	/**< @brief Unique IP address of the NAS (nas-ip-address).  */
  char * nasip_orig;	/**< @brief Unique IP address of the NAS (nas-ip-address) original value given at command line.  */
  const char *nasip_help; /**< @brief Unique IP address of the NAS (nas-ip-address) help description.  */
  char * ssid_arg;	/**< @brief SSID of the session.  */
  char * ssid_orig;	/**< @brief SSID of the session original value given at command line.  */
  const char *ssid_help; /**< @brief SSID of the session help description.  */
  char * vlan_arg;	/**< @brief VLAN of the session.  */
  char * vlan_orig;	/**< @brief VLAN of the session original value given at command line.  */
  const char *vlan_help; /**< @brief VLAN of the session help description.  */
  int ieee8021q_flag;	/**< @brief Support 802.1Q VLAN tagging (default=off).  */
  const char *ieee8021q_help; /**< @brief Support 802.1Q VLAN tagging help description.  */
  char * cmdsocket_arg;	/**< @brief path to the command unix socket.  */
  char * cmdsocket_orig;	/**< @brief path to the command unix socket original value given at command line.  */
  const char *cmdsocket_help; /**< @brief path to the command unix socket help description.  */
  int radiusoriginalurl_flag;	/**< @brief Turn on the sending of ChilliSpot-OriginalURL in Access-Request (default=off).  */
  const char *radiusoriginalurl_help; /**< @brief Turn on the sending of ChilliSpot-OriginalURL in Access-Request help description.  */
  int swapoctets_flag;	/**< @brief Swap the meaning of input/output octets/packets (default=off).  */
  const char *swapoctets_help; /**< @brief Swap the meaning of input/output octets/packets help description.  */
  char * usestatusfile_arg;	/**< @brief Use the status file to keep track of sessions.  */
  char * usestatusfile_orig;	/**< @brief Use the status file to keep track of sessions original value given at command line.  */
  const char *usestatusfile_help; /**< @brief Use the status file to keep track of sessions help description.  */
  char * localusers_arg;	/**< @brief File keep 'Local' usernames and passwords.  */
  char * localusers_orig;	/**< @brief File keep 'Local' usernames and passwords original value given at command line.  */
  const char *localusers_help; /**< @brief File keep 'Local' usernames and passwords help description.  */
  char * postauthproxy_arg;	/**< @brief IP of an upstream transparent proxy.  */
  char * postauthproxy_orig;	/**< @brief IP of an upstream transparent proxy original value given at command line.  */
  const char *postauthproxy_help; /**< @brief IP of an upstream transparent proxy help description.  */
  int postauthproxyport_arg;	/**< @brief Port of an upstream transparent proxy (default='0').  */
  char * postauthproxyport_orig;	/**< @brief Port of an upstream transparent proxy original value given at command line.  */
  const char *postauthproxyport_help; /**< @brief Port of an upstream transparent proxy help description.  */
  int wpaguests_flag;	/**< @brief Allow WPA 'Guest' access (default=off).  */
  const char *wpaguests_help; /**< @brief Allow WPA 'Guest' access help description.  */
  int openidauth_flag;	/**< @brief Allow OpenID authentication (default=off).  */
  const char *openidauth_help; /**< @brief Allow OpenID authentication help description.  */
  int papalwaysok_flag;	/**< @brief Always allow 'PAP' authentication (depreciated; always on) (default=off).  */
  const char *papalwaysok_help; /**< @brief Always allow 'PAP' authentication (depreciated; always on) help description.  */
  int mschapv2_flag;	/**< @brief Use MSCHAPv2 authentication where possible (default=off).  */
  const char *mschapv2_help; /**< @brief Use MSCHAPv2 authentication where possible help description.  */
  int chillixml_flag;	/**< @brief Use ChilliSpot XML in WISPr blocks (default=off).  */
  const char *chillixml_help; /**< @brief Use ChilliSpot XML in WISPr blocks help description.  */
  int acctupdate_flag;	/**< @brief Allow updating of session attributes in Accounting-Response (default=off).  */
  const char *acctupdate_help; /**< @brief Allow updating of session attributes in Accounting-Response help description.  */
  int dnsparanoia_flag;	/**< @brief Inspect DNS packets and drop responses with any non- A, CNAME, SOA, or MX records (to prevent dns tunnels) (default=off).  */
  const char *dnsparanoia_help; /**< @brief Inspect DNS packets and drop responses with any non- A, CNAME, SOA, or MX records (to prevent dns tunnels) help description.  */
  int seskeepalive_flag;	/**< @brief Keep sessions 'alive' after a restart of the server (default=off).  */
  const char *seskeepalive_help; /**< @brief Keep sessions 'alive' after a restart of the server help description.  */
  int usetap_flag;	/**< @brief Use a TAP instead of TUN (linux only) (default=off).  */
  const char *usetap_help; /**< @brief Use a TAP instead of TUN (linux only) help description.  */
  char * routeif_arg;	/**< @brief Interface to use as default route; turns on 'manual' routing.  */
  char * routeif_orig;	/**< @brief Interface to use as default route; turns on 'manual' routing original value given at command line.  */
  const char *routeif_help; /**< @brief Interface to use as default route; turns on 'manual' routing help description.  */
  int framedservice_flag;	/**< @brief Use Service-Type = Framed instead of Login (default=off).  */
  const char *framedservice_help; /**< @brief Use Service-Type = Framed instead of Login help description.  */
  int tcpwin_arg;	/**< @brief Change TCP window size to this value to help prevent congestion (default='0').  */
  char * tcpwin_orig;	/**< @brief Change TCP window size to this value to help prevent congestion original value given at command line.  */
  const char *tcpwin_help; /**< @brief Change TCP window size to this value to help prevent congestion help description.  */
  int tcpmss_arg;	/**< @brief Change TCP maximum window size (mss) option in TCP traffic (default='0').  */
  char * tcpmss_orig;	/**< @brief Change TCP maximum window size (mss) option in TCP traffic original value given at command line.  */
  const char *tcpmss_help; /**< @brief Change TCP maximum window size (mss) option in TCP traffic help description.  */
  int maxclients_arg;	/**< @brief Maximum number of clients/subscribers (default='512').  */
  char * maxclients_orig;	/**< @brief Maximum number of clients/subscribers original value given at command line.  */
  const char *maxclients_help; /**< @brief Maximum number of clients/subscribers help description.  */
  int challengetimeout_arg;	/**< @brief Timeout in seconds for the generated challenge (default='600').  */
  char * challengetimeout_orig;	/**< @brief Timeout in seconds for the generated challenge original value given at command line.  */
  const char *challengetimeout_help; /**< @brief Timeout in seconds for the generated challenge help description.  */
  int challengetimeout2_arg;	/**< @brief Timeout in seconds for challenge during login (default='1200').  */
  char * challengetimeout2_orig;	/**< @brief Timeout in seconds for challenge during login original value given at command line.  */
  const char *challengetimeout2_help; /**< @brief Timeout in seconds for challenge during login help description.  */
  char * sslkeyfile_arg;	/**< @brief SSL private key file in PEM format.  */
  char * sslkeyfile_orig;	/**< @brief SSL private key file in PEM format original value given at command line.  */
  const char *sslkeyfile_help; /**< @brief SSL private key file in PEM format help description.  */
  char * sslkeypass_arg;	/**< @brief SSL private key password.  */
  char * sslkeypass_orig;	/**< @brief SSL private key password original value given at command line.  */
  const char *sslkeypass_help; /**< @brief SSL private key password help description.  */
  char * sslcertfile_arg;	/**< @brief SSL certificate file in PEM format.  */
  char * sslcertfile_orig;	/**< @brief SSL certificate file in PEM format original value given at command line.  */
  const char *sslcertfile_help; /**< @brief SSL certificate file in PEM format help description.  */
  char * sslcafile_arg;	/**< @brief SSL CA certificate file in PEM format.  */
  char * sslcafile_orig;	/**< @brief SSL CA certificate file in PEM format original value given at command line.  */
  const char *sslcafile_help; /**< @brief SSL CA certificate file in PEM format help description.  */
  char * unixipc_arg;	/**< @brief The UNIX IPC Filename to use when compiled with --with-unixipc.  */
  char * unixipc_orig;	/**< @brief The UNIX IPC Filename to use when compiled with --with-unixipc original value given at command line.  */
  const char *unixipc_help; /**< @brief The UNIX IPC Filename to use when compiled with --with-unixipc help description.  */
  int uamallowpost_flag;	/**< @brief Enable to allow a HTTP POST to the standard uamport interface (default=off).  */
  const char *uamallowpost_help; /**< @brief Enable to allow a HTTP POST to the standard uamport interface help description.  */
  char * natip_arg;	/**< @brief IP to use when doing nat on WAN (routeidx).  */
  char * natip_orig;	/**< @brief IP to use when doing nat on WAN (routeidx) original value given at command line.  */
  const char *natip_help; /**< @brief IP to use when doing nat on WAN (routeidx) help description.  */
  int natport_arg;	/**< @brief Port to use when oding nat on the WAN (routeidx) (default='0').  */
  char * natport_orig;	/**< @brief Port to use when oding nat on the WAN (routeidx) original value given at command line.  */
  const char *natport_help; /**< @brief Port to use when oding nat on the WAN (routeidx) help description.  */
  int redirssl_flag;	/**< @brief Enable redirection of SSL/HTTP port (requires SSL support) (default=off).  */
  const char *redirssl_help; /**< @brief Enable redirection of SSL/HTTP port (requires SSL support) help description.  */
  int uamuissl_flag;	/**< @brief Enable SSL/HTTPS support on the uamuiport (default=off).  */
  const char *uamuissl_help; /**< @brief Enable SSL/HTTPS support on the uamuiport help description.  */
  char * kname_arg;	/**< @brief Enable the use of the coova kernel module instance of this namem.  */
  char * kname_orig;	/**< @brief Enable the use of the coova kernel module instance of this namem original value given at command line.  */
  const char *kname_help; /**< @brief Enable the use of the coova kernel module instance of this namem help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int fg_given ;	/**< @brief Whether fg was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int bin_given ;	/**< @brief Whether bin was given.  */
  unsigned int reload_given ;	/**< @brief Whether reload was given.  */
  unsigned int debugfacility_given ;	/**< @brief Whether debugfacility was given.  */
  unsigned int logfacility_given ;	/**< @brief Whether logfacility was given.  */
  unsigned int conf_given ;	/**< @brief Whether conf was given.  */
  unsigned int interval_given ;	/**< @brief Whether interval was given.  */
  unsigned int pidfile_given ;	/**< @brief Whether pidfile was given.  */
  unsigned int statedir_given ;	/**< @brief Whether statedir was given.  */
  unsigned int uid_given ;	/**< @brief Whether uid was given.  */
  unsigned int gid_given ;	/**< @brief Whether gid was given.  */
  unsigned int net_given ;	/**< @brief Whether net was given.  */
  unsigned int dhcpstart_given ;	/**< @brief Whether dhcpstart was given.  */
  unsigned int dhcpend_given ;	/**< @brief Whether dhcpend was given.  */
  unsigned int dhcpbroadcast_given ;	/**< @brief Whether dhcpbroadcast was given.  */
  unsigned int dynip_given ;	/**< @brief Whether dynip was given.  */
  unsigned int nodynip_given ;	/**< @brief Whether nodynip was given.  */
  unsigned int statip_given ;	/**< @brief Whether statip was given.  */
  unsigned int anyipexclude_given ;	/**< @brief Whether anyipexclude was given.  */
  unsigned int dns1_given ;	/**< @brief Whether dns1 was given.  */
  unsigned int dns2_given ;	/**< @brief Whether dns2 was given.  */
  unsigned int domain_given ;	/**< @brief Whether domain was given.  */
  unsigned int ipup_given ;	/**< @brief Whether ipup was given.  */
  unsigned int ipdown_given ;	/**< @brief Whether ipdown was given.  */
  unsigned int conup_given ;	/**< @brief Whether conup was given.  */
  unsigned int condown_given ;	/**< @brief Whether condown was given.  */
  unsigned int txqlen_given ;	/**< @brief Whether txqlen was given.  */
  unsigned int tundev_given ;	/**< @brief Whether tundev was given.  */
  unsigned int mtu_given ;	/**< @brief Whether mtu was given.  */
  unsigned int autostatip_given ;	/**< @brief Whether autostatip was given.  */
  unsigned int ringsize_given ;	/**< @brief Whether ringsize was given.  */
  unsigned int sndbuf_given ;	/**< @brief Whether sndbuf was given.  */
  unsigned int rcvbuf_given ;	/**< @brief Whether rcvbuf was given.  */
  unsigned int radiuslisten_given ;	/**< @brief Whether radiuslisten was given.  */
  unsigned int radiusserver1_given ;	/**< @brief Whether radiusserver1 was given.  */
  unsigned int radiusserver2_given ;	/**< @brief Whether radiusserver2 was given.  */
  unsigned int radiusauthport_given ;	/**< @brief Whether radiusauthport was given.  */
  unsigned int radiusacctport_given ;	/**< @brief Whether radiusacctport was given.  */
  unsigned int radiussecret_given ;	/**< @brief Whether radiussecret was given.  */
  unsigned int radiustimeout_given ;	/**< @brief Whether radiustimeout was given.  */
  unsigned int radiusretry_given ;	/**< @brief Whether radiusretry was given.  */
  unsigned int radiusretrysec_given ;	/**< @brief Whether radiusretrysec was given.  */
  unsigned int radiusnasid_given ;	/**< @brief Whether radiusnasid was given.  */
  unsigned int radiuslocationid_given ;	/**< @brief Whether radiuslocationid was given.  */
  unsigned int radiuslocationname_given ;	/**< @brief Whether radiuslocationname was given.  */
  unsigned int locationname_given ;	/**< @brief Whether locationname was given.  */
  unsigned int radiusnasporttype_given ;	/**< @brief Whether radiusnasporttype was given.  */
  unsigned int coaport_given ;	/**< @brief Whether coaport was given.  */
  unsigned int coanoipcheck_given ;	/**< @brief Whether coanoipcheck was given.  */
  unsigned int proxylisten_given ;	/**< @brief Whether proxylisten was given.  */
  unsigned int proxyport_given ;	/**< @brief Whether proxyport was given.  */
  unsigned int proxyclient_given ;	/**< @brief Whether proxyclient was given.  */
  unsigned int proxysecret_given ;	/**< @brief Whether proxysecret was given.  */
  unsigned int proxymacaccept_given ;	/**< @brief Whether proxymacaccept was given.  */
  unsigned int proxylocattr_given ;	/**< @brief Whether proxylocattr was given.  */
  unsigned int dhcpif_given ;	/**< @brief Whether dhcpif was given.  */
  unsigned int dhcpmac_given ;	/**< @brief Whether dhcpmac was given.  */
  unsigned int dhcpmacset_given ;	/**< @brief Whether dhcpmacset was given.  */
  unsigned int nexthop_given ;	/**< @brief Whether nexthop was given.  */
  unsigned int dhcpradius_given ;	/**< @brief Whether dhcpradius was given.  */
  unsigned int dhcpgateway_given ;	/**< @brief Whether dhcpgateway was given.  */
  unsigned int dhcpgatewayport_given ;	/**< @brief Whether dhcpgatewayport was given.  */
  unsigned int dhcprelayagent_given ;	/**< @brief Whether dhcprelayagent was given.  */
  unsigned int lease_given ;	/**< @brief Whether lease was given.  */
  unsigned int noc2c_given ;	/**< @brief Whether noc2c was given.  */
  unsigned int eapolenable_given ;	/**< @brief Whether eapolenable was given.  */
  unsigned int uamserver_given ;	/**< @brief Whether uamserver was given.  */
  unsigned int uamhomepage_given ;	/**< @brief Whether uamhomepage was given.  */
  unsigned int uamsecret_given ;	/**< @brief Whether uamsecret was given.  */
  unsigned int uamlisten_given ;	/**< @brief Whether uamlisten was given.  */
  unsigned int dhcplisten_given ;	/**< @brief Whether dhcplisten was given.  */
  unsigned int uamport_given ;	/**< @brief Whether uamport was given.  */
  unsigned int uamuiport_given ;	/**< @brief Whether uamuiport was given.  */
  unsigned int uamallowed_given ;	/**< @brief Whether uamallowed was given.  */
  unsigned int uamdomain_given ;	/**< @brief Whether uamdomain was given.  */
  unsigned int uamregex_given ;	/**< @brief Whether uamregex was given.  */
  unsigned int uamanydns_given ;	/**< @brief Whether uamanydns was given.  */
  unsigned int uamanyip_given ;	/**< @brief Whether uamanyip was given.  */
  unsigned int uamnatanyip_given ;	/**< @brief Whether uamnatanyip was given.  */
  unsigned int wisprlogin_given ;	/**< @brief Whether wisprlogin was given.  */
  unsigned int nouamsuccess_given ;	/**< @brief Whether nouamsuccess was given.  */
  unsigned int nowispr1_given ;	/**< @brief Whether nowispr1 was given.  */
  unsigned int nowispr2_given ;	/**< @brief Whether nowispr2 was given.  */
  unsigned int uamlogoutip_given ;	/**< @brief Whether uamlogoutip was given.  */
  unsigned int uamaliasip_given ;	/**< @brief Whether uamaliasip was given.  */
  unsigned int uamaliasname_given ;	/**< @brief Whether uamaliasname was given.  */
  unsigned int uamhostname_given ;	/**< @brief Whether uamhostname was given.  */
  unsigned int uamaaaurl_given ;	/**< @brief Whether uamaaaurl was given.  */
  unsigned int domaindnslocal_given ;	/**< @brief Whether domaindnslocal was given.  */
  unsigned int radsec_given ;	/**< @brief Whether radsec was given.  */
  unsigned int defsessiontimeout_given ;	/**< @brief Whether defsessiontimeout was given.  */
  unsigned int defidletimeout_given ;	/**< @brief Whether defidletimeout was given.  */
  unsigned int defbandwidthmaxdown_given ;	/**< @brief Whether defbandwidthmaxdown was given.  */
  unsigned int defbandwidthmaxup_given ;	/**< @brief Whether defbandwidthmaxup was given.  */
  unsigned int definteriminterval_given ;	/**< @brief Whether definteriminterval was given.  */
  unsigned int bwbucketupsize_given ;	/**< @brief Whether bwbucketupsize was given.  */
  unsigned int bwbucketdnsize_given ;	/**< @brief Whether bwbucketdnsize was given.  */
  unsigned int bwbucketminsize_given ;	/**< @brief Whether bwbucketminsize was given.  */
  unsigned int macauth_given ;	/**< @brief Whether macauth was given.  */
  unsigned int macreauth_given ;	/**< @brief Whether macreauth was given.  */
  unsigned int macauthdeny_given ;	/**< @brief Whether macauthdeny was given.  */
  unsigned int macallowed_given ;	/**< @brief Whether macallowed was given.  */
  unsigned int macsuffix_given ;	/**< @brief Whether macsuffix was given.  */
  unsigned int macpasswd_given ;	/**< @brief Whether macpasswd was given.  */
  unsigned int macallowlocal_given ;	/**< @brief Whether macallowlocal was given.  */
  unsigned int strictmacauth_given ;	/**< @brief Whether strictmacauth was given.  */
  unsigned int wwwdir_given ;	/**< @brief Whether wwwdir was given.  */
  unsigned int wwwbin_given ;	/**< @brief Whether wwwbin was given.  */
  unsigned int uamui_given ;	/**< @brief Whether uamui was given.  */
  unsigned int adminuser_given ;	/**< @brief Whether adminuser was given.  */
  unsigned int adminpasswd_given ;	/**< @brief Whether adminpasswd was given.  */
  unsigned int adminupdatefile_given ;	/**< @brief Whether adminupdatefile was given.  */
  unsigned int rtmonfile_given ;	/**< @brief Whether rtmonfile was given.  */
  unsigned int ethers_given ;	/**< @brief Whether ethers was given.  */
  unsigned int nasmac_given ;	/**< @brief Whether nasmac was given.  */
  unsigned int nasip_given ;	/**< @brief Whether nasip was given.  */
  unsigned int ssid_given ;	/**< @brief Whether ssid was given.  */
  unsigned int vlan_given ;	/**< @brief Whether vlan was given.  */
  unsigned int ieee8021q_given ;	/**< @brief Whether ieee8021q was given.  */
  unsigned int cmdsocket_given ;	/**< @brief Whether cmdsocket was given.  */
  unsigned int radiusoriginalurl_given ;	/**< @brief Whether radiusoriginalurl was given.  */
  unsigned int swapoctets_given ;	/**< @brief Whether swapoctets was given.  */
  unsigned int usestatusfile_given ;	/**< @brief Whether usestatusfile was given.  */
  unsigned int localusers_given ;	/**< @brief Whether localusers was given.  */
  unsigned int postauthproxy_given ;	/**< @brief Whether postauthproxy was given.  */
  unsigned int postauthproxyport_given ;	/**< @brief Whether postauthproxyport was given.  */
  unsigned int wpaguests_given ;	/**< @brief Whether wpaguests was given.  */
  unsigned int openidauth_given ;	/**< @brief Whether openidauth was given.  */
  unsigned int papalwaysok_given ;	/**< @brief Whether papalwaysok was given.  */
  unsigned int mschapv2_given ;	/**< @brief Whether mschapv2 was given.  */
  unsigned int chillixml_given ;	/**< @brief Whether chillixml was given.  */
  unsigned int acctupdate_given ;	/**< @brief Whether acctupdate was given.  */
  unsigned int dnsparanoia_given ;	/**< @brief Whether dnsparanoia was given.  */
  unsigned int seskeepalive_given ;	/**< @brief Whether seskeepalive was given.  */
  unsigned int usetap_given ;	/**< @brief Whether usetap was given.  */
  unsigned int routeif_given ;	/**< @brief Whether routeif was given.  */
  unsigned int framedservice_given ;	/**< @brief Whether framedservice was given.  */
  unsigned int tcpwin_given ;	/**< @brief Whether tcpwin was given.  */
  unsigned int tcpmss_given ;	/**< @brief Whether tcpmss was given.  */
  unsigned int maxclients_given ;	/**< @brief Whether maxclients was given.  */
  unsigned int challengetimeout_given ;	/**< @brief Whether challengetimeout was given.  */
  unsigned int challengetimeout2_given ;	/**< @brief Whether challengetimeout2 was given.  */
  unsigned int sslkeyfile_given ;	/**< @brief Whether sslkeyfile was given.  */
  unsigned int sslkeypass_given ;	/**< @brief Whether sslkeypass was given.  */
  unsigned int sslcertfile_given ;	/**< @brief Whether sslcertfile was given.  */
  unsigned int sslcafile_given ;	/**< @brief Whether sslcafile was given.  */
  unsigned int unixipc_given ;	/**< @brief Whether unixipc was given.  */
  unsigned int uamallowpost_given ;	/**< @brief Whether uamallowpost was given.  */
  unsigned int natip_given ;	/**< @brief Whether natip was given.  */
  unsigned int natport_given ;	/**< @brief Whether natport was given.  */
  unsigned int redirssl_given ;	/**< @brief Whether redirssl was given.  */
  unsigned int uamuissl_given ;	/**< @brief Whether uamuissl was given.  */
  unsigned int kname_given ;	/**< @brief Whether kname was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
